/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.Objs;

import BryceMath.DoubleMath.Vector;
import BryceMath.Geometry.Rectangle;
import Data_Structures.Structures.HashingClasses.AArray;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.Obj_Container;
import java.util.Iterator;

public abstract class Obj_union
extends Obj
implements Iterable<Obj> {
    private AArray<Obj, Vector> initial_positions;
    private AArray<Obj, Vector> positions;
    private int obj_depths = 0;
    public List<Obj> objs;
    private int w;
    private int h;

    public Obj_union(double x, double y, int w, int h) {
        super(x, y);
        this.iVars(w, h);
    }

    public Obj_union(Rectangle bounds) {
        super(bounds.getX(), bounds.getY());
        this.iVars(bounds.getW(), bounds.getH());
    }

    private void iVars(int w, int h) {
        this.w = w;
        this.h = h;
        this.objs = new List();
        this.positions = new AArray();
        this.initial_positions = new AArray();
        this.collidable = false;
    }

    @Override
    public void initialize() {
        this.initialized = true;
        this.iObjs();
        this.obj_create(this);
    }

    public abstract void iObjs();

    public Obj obj_create(Obj o) {
        this.objs.add(o);
        if (o != this && this.myContainer != null) {
            this.myContainer.obj_create(o);
        }
        Vector orgin = new Vector(this.x_start, this.y_start);
        Vector position_new = o.getPositionVector();
        Vector offset = this.getPositionVector().sub(orgin);
        this.insert(o, position_new);
        this.initial_positions.insert(o, position_new.sub(offset));
        if (!this.isEnabled()) {
            o.disable();
        }
        return o;
    }

    public boolean remove(Obj o) {
        if (o == this) {
            throw new Error("Unions can not remove themselves from themselves!");
        }
        Iterator<Obj> iter2 = this.objs.iterator();
        while (iter2.hasNext()) {
            Obj o2 = iter2.next();
            if (!o2.equals(o)) continue;
            iter2.remove();
        }
        this.positions.remove_key(o);
        return this.initial_positions.remove_key(o);
    }

    @Override
    public void update() {
    }

    @Override
    public void endStep() {
        this.updateDepths();
        this.updatePositions();
        this.updateDeath();
    }

    private void updateDepths() {
        int depth_new = this.obj_depths;
        for (Obj o : this.objs) {
            int depth = o.getDepth();
            if (depth == this.obj_depths) continue;
            depth_new = depth;
        }
        if (depth_new == this.obj_depths) {
            return;
        }
        this.obj_depths = depth_new;
        for (Obj o : this.objs) {
            o.setDepth(depth_new);
        }
    }

    private void updatePositions() {
        Vector change = this.getPosChange();
        if (!change.equals(new Vector(0.0, 0.0))) {
            this.offsetPositions(change);
        }
    }

    private Vector getPosChange() {
        Vector change = new Vector(0.0, 0.0);
        int num_changes = 0;
        for (Obj o : this.objs) {
            Vector pos_current;
            Vector pos_previous = this.lookup(o);
            if (pos_previous.equals(pos_current = o.getPositionVector())) continue;
            Vector sub_change = pos_current.sub(pos_previous);
            change = change.add(sub_change);
            ++num_changes;
        }
        if (num_changes > 0) {
            return change.div(num_changes);
        }
        return change;
    }

    private void offsetPositions(Vector offset) {
        for (Obj o : this) {
            Vector pos_previous = this.lookup(o);
            Vector pos_new = pos_previous.add(offset);
            o.setX(pos_new.get(0));
            o.setY(pos_new.get(1));
            this.update(o);
        }
    }

    public void revertPositions() {
        for (Obj o : this) {
            Vector i_pos = this.initial_positions.lookup(o);
            this.positions.insert(o, i_pos);
            o.setX(i_pos.getX());
            o.setY(i_pos.getY());
        }
    }

    private void insert(Obj o, Vector position) {
        this.positions.insert(o, position);
    }

    protected void update(Obj o) {
    }

    private Vector lookup(Obj o) {
        return this.positions.lookup(o);
    }

    private void updateDeath() {
        boolean shouldKill = false;
        for (Obj o : this.objs) {
            if (!o.dead()) continue;
            shouldKill = true;
            break;
        }
        if (!shouldKill) {
            return;
        }
        this.killAll();
    }

    @Override
    public void die() {
        this.killAll();
    }

    private void killAll() {
        super.die();
        for (Obj o : this.objs) {
            if (o == this) continue;
            o.die();
        }
    }

    @Override
    public void kill(Obj_Container container) {
        super.kill(container);
        for (Obj o : this) {
            if (o == this) continue;
            o.kill(container);
        }
    }

    @Override
    public int getW() {
        return this.w;
    }

    @Override
    public int getH() {
        return this.h;
    }

    @Override
    public void setW(int w_in) {
        this.w = w_in;
    }

    @Override
    public void setH(int h_in) {
        this.h = h_in;
    }

    @Override
    public Iterator<Obj> iterator() {
        return this.objs.iterator();
    }

    @Override
    public void disable() {
        super.disable();
        for (Obj o : this) {
            if (o == this) continue;
            o.disable();
        }
    }

    @Override
    public void enable() {
        super.enable();
        for (Obj o : this) {
            if (o == this) continue;
            o.enable();
        }
    }

    @Override
    public void setCollidable(boolean flag) {
        super.setCollidable(flag);
        for (Obj o : this) {
            if (o == this) continue;
            o.setCollidable(flag);
        }
    }

    public boolean contains(Obj o) {
        return this.objs.contains(o);
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        for (Obj o : this) {
            if (o == this) continue;
            o.setVisible(flag);
        }
    }
}

